--- OLD/xc/programs/xauth/gethost.c	Thu Jan  1 00:00:00 1970
+++ NEW/xc/programs/xauth/gethost.c	Thu Jan  1 00:00:00 1970
@@ -153,32 +153,45 @@
 /*
  * cribbed from lib/X/XConnDis.c
  */
-static Bool get_inet_address (name, resultp)
+static int get_inet_address (name, resultp)
     char *name;
-    unsigned long *resultp;		/* return */
+    unsigned long int **resultp;	/* return */
 {
-    unsigned long hostinetaddr = inet_addr (name);
+    unsigned long int *addrs;
     struct hostent *host_ptr;
-    struct sockaddr_in inaddr;		/* dummy variable for size calcs */
+    struct in_addr ia;
+    int n;
 
-    if (hostinetaddr == -1) {		/* oh, gross.... */
-	if ((host_ptr = gethostbyname (name)) == NULL) {
-	    /* No such host! */
-	    errno = EINVAL;
-	    return False;
-	}
-	/* Check the address type for an internet host. */
-	if (host_ptr->h_addrtype != AF_INET) {
-	    /* Not an Internet host! */
-	    errno = EPROTOTYPE;
-	    return False;
-	}
- 
-	memmove( (char *)&hostinetaddr, (char *)host_ptr->h_addr, 
-	      sizeof(inaddr.sin_addr));
+    if (inet_aton (name, &ia)) {
+	addrs = malloc(sizeof(*addrs));
+	if (addrs == 0) return 0;
+	addrs[0] = ia.s_addr; /* no ntohl(!) */
+	*resultp = addrs;
+	return 1;
     }
-    *resultp = hostinetaddr;
-    return True;
+    host_ptr = gethostbyname (name);
+    if (host_ptr == 0) {
+	/* No such host! */
+	errno = EINVAL; /* XXX overloaded */
+	return 0;
+    }
+    /* Check the address type and size. */
+    if ( (host_ptr->h_addrtype != AF_INET) ||
+	 (host_ptr->h_length != sizeof(struct in_addr)) ) {
+	/* Not an Internet host! */
+	errno = EPROTOTYPE; /* XXX overloaded */
+	return 0;
+    }
+    for (n = 0; host_ptr->h_addr_list[n]; n++)
+	;
+    addrs = malloc (n * sizeof(*addrs));
+    if (addrs == 0) return 0;
+    for (n = 0; host_ptr->h_addr_list[n]; n++) {
+	memcpy (&ia, host_ptr->h_addr_list[n], sizeof(struct in_addr));
+	addrs[n] = ia.s_addr; /* no ntohl(!) */
+    }
+    *resultp = addrs;
+    return n;
 }
 #endif
 
@@ -202,19 +215,20 @@
 }
 #endif
 
-char *get_address_info (family, fulldpyname, prefix, host, lenp)
+void **get_address_info (family, fulldpyname, prefix, host, lenp)
     int family;
     char *fulldpyname;
     int prefix;
     char *host;
     int *lenp;
 {
-    char *retval = NULL;
-    int len = 0;
-    char *src = NULL;
+    void **rv;
+    int len;
+    char *src;
 #ifdef TCPCONN
-    unsigned long hostinetaddr;
-    struct sockaddr_in inaddr;		/* dummy variable for size calcs */
+    unsigned long int *hostinetaddrs;
+    int ninetaddrs;
+    int i;
 #endif
 #ifdef DNETCONN
     struct dn_naddr dnaddr;
@@ -233,7 +247,7 @@
 	    extern char *get_local_hostname();
 
 	    if (!get_local_hostname (buf, sizeof buf)) {
-		len = 0;
+		return 0;
 	    } else {
 		src = buf;
 		len = strlen (buf);
@@ -242,39 +256,54 @@
 	    src = fulldpyname;
 	    len = prefix;
 	}
+	rv = malloc (2 * sizeof(void *));
+	if (! rv) return 0;
+	rv[0] = malloc (len);
+	if (! rv[0]) {
+	    free(rv);
+	    return 0;
+	}
+	rv[1] = 0;
+	memcpy (rv, src, len);
+	*lenp = len;
+	return rv;
 	break;
       case FamilyInternet:		/* host:0 */
 #ifdef TCPCONN
-	if (!get_inet_address (host, &hostinetaddr)) return NULL;
-	src = (char *) &hostinetaddr;
-	len = 4; /* sizeof inaddr.sin_addr, would fail on Cray */
-	break;
-#else
-	return NULL;
+	ninetaddrs = get_inet_address (host, &hostinetaddrs);
+	if (ninetaddrs < 1) return 0;
+	rv = malloc ((ninetaddrs+1) * sizeof(void *));
+	if (! rv) return 0;
+	for (i = 0; i < ninetaddrs; i++) {
+	    rv[i] = malloc (sizeof(struct in_addr));
+	    if (! rv[i]) {
+		for (i--; i >= 0; i--) free (rv[i]);
+		free (rv);
+		return 0;
+	    }
+	    ((struct in_addr *)rv[i])->s_addr = hostinetaddrs[i];
+	}
+	rv[ninetaddrs] = 0;
+	*lenp = sizeof(struct in_addr);
+	return rv;
 #endif
+	break;
       case FamilyDECnet:		/* host::0 */
 #ifdef DNETCONN
 	if (!get_dnet_address (host, &dnaddr)) return NULL;
-	src = (char *) &dnaddr;
-	len = (sizeof dnaddr);
-	break;
-#else
-	/* fall through since we don't have code for it */
+	rv = malloc (2 * sizeof(void *));
+	if (! rv) return 0;
+	rv[0] = malloc (sizeof(dnaddr));
+	if (! rv[0]) {
+	    free(rv);
+	    return 0;
+	}
+	rv[1] = 0;
+	memcpy (rv, &dnaddr, sizeof(dnaddr));
+	*lenp = sizeof(dnaddr);
+	return rv;
 #endif
-      default:
-	src = NULL;
-	len = 0;
-    }
-
-    /*
-     * if source was provided, allocate space and copy it
-     */
-    if (len == 0 || !src) return NULL;
-
-    retval = malloc (len);
-    if (retval) {
-	memmove( retval, src, len);
-	*lenp = len;
+	break;
     }
-    return retval;
+    return 0;
 }
