--- .empty	Thu Jan  1 00:00:00 1970
+++ NEW/xc/programs/Xserver/hw/next/nextInit.c	Thu Jan  1 00:00:00 1970
@@ -0,0 +1,725 @@
+/*
+ * nextInit.c --
+ *	Initialization functions for screen/keyboard/mouse, etc.
+ *
+ * Public domain.
+ */
+#include <stdio.h>
+
+#include <errno.h>
+#include <fcntl.h>
+#include <signal.h>
+#include <sys/mman.h>
+#include <sys/ioctl.h>
+#include <dev/wscons/wsconsio.h>
+
+#include "input.h"
+#include "inputstr.h"
+#include "servermd.h"
+#include "mipointer.h"
+#include "screenint.h"
+#include "scrnintstr.h"
+#include "colormapst.h"
+
+/* XXX the define of PSZ shouldn't be needed; all we want from cfb.h
+   are declarations for cfbInstallColormap and the like. */
+#define PSZ 2
+#include "cfb.h"
+
+#define XK_LATIN1
+#define XK_MISCELLANY
+#include "keysymdef.h"
+
+extern int monitorResolution;
+
+#ifdef XKB
+#include <X11/extensions/XKBstr.h>
+extern int noXkbExtension;
+#endif
+
+#define UNUSED __attribute__((__unused__))
+
+extern void UseMsg(void);
+extern Bool PointerConfinedToScreen(void);
+
+/* XXX should collect this stuff into a state struct
+   and support multiple screens! */
+static int nkfd = -1;
+static int fbfd = -1;
+static int ar1 = 400;
+static int ar2 = 50;
+static unsigned long int generation = 0;
+static int inx;
+static void *vram = 0;
+static struct timeval now;
+static unsigned int nowms;
+
+#define KEYCODE_OFFSET 7 /* protocol minimum is 8, our first is 1 */
+
+static CARD8 modmap[MAP_LENGTH]
+ = { [0x51+KEYCODE_OFFSET] ControlMask,
+     [0x52+KEYCODE_OFFSET] ShiftMask,
+     [0x53+KEYCODE_OFFSET] ShiftMask,
+     [0x54+KEYCODE_OFFSET] Mod1Mask,
+     [0x55+KEYCODE_OFFSET] Mod1Mask };
+
+/* Note that "kb" numbers are offset by KEYCODE_OFFSET on the wire. */
+#define HOLE NoSymbol, NoSymbol
+static KeySym keysymvec[((0x57-0x01)+1)*2]	/* kb label */
+ = { NoSymbol, NoSymbol,			/* 01 brightness-down */
+     NoSymbol, NoSymbol,			/* 02 sound-down */
+     XK_backslash, XK_bar,			/* 03 \ | */
+     XK_bracketright, XK_braceright,	/*{*/	/* 04 ] } */
+     XK_bracketleft, XK_braceleft,		/* 05 [ { */	/*}*/
+     XK_I, NoSymbol,				/* 06 i */
+     XK_O, NoSymbol,				/* 07 o */
+     XK_P, NoSymbol,				/* 08 p */
+     XK_Left, NoSymbol,				/* 09 left-arrow */
+     HOLE,					/* 0a */
+     XK_KP_0, NoSymbol,				/* 0b keypad 0 */
+     XK_KP_Decimal, NoSymbol,			/* 0c keypad . */
+     XK_KP_Enter, NoSymbol,			/* 0d keypad enter */
+     HOLE,					/* 0e */
+     XK_Down, NoSymbol,				/* 0f down-arrow */
+     XK_Right, NoSymbol,			/* 10 right-arrow */
+     XK_KP_1, NoSymbol,				/* 11 keypad 1 */
+     XK_KP_4, NoSymbol,				/* 12 keypad 4 */
+     XK_KP_6, NoSymbol,				/* 13 keypad 6 */
+     XK_KP_3, NoSymbol,				/* 14 keypad 3 */
+     XK_KP_Add, NoSymbol,			/* 15 keypad + */
+     XK_Up, NoSymbol,				/* 16 up-arrow */
+     XK_KP_2, NoSymbol,				/* 17 keypad 2 */
+     XK_KP_5, NoSymbol,				/* 18 keypad 5 */
+     NoSymbol, NoSymbol,			/* 19 brightness-up */
+     NoSymbol, NoSymbol,			/* 1a sound-up */
+     XK_BackSpace, XK_Delete,			/* 1b backspace */
+     XK_equal, XK_plus,				/* 1c = + */
+     XK_minus, XK_underscore,			/* 1d - _ */
+     XK_8, XK_asterisk,				/* 1e 8 * */
+     XK_9, XK_parenleft,			/* 1f 9 ( */
+     XK_0, XK_parenright,			/* 20 0 ) */
+     XK_KP_7, NoSymbol,				/* 21 keypad 7 */
+     XK_KP_8, NoSymbol,				/* 22 keypad 8 */
+     XK_KP_9, NoSymbol,				/* 23 keypad 9 */
+     XK_KP_Subtract, NoSymbol,			/* 24 keypad - */
+     XK_KP_Multiply, NoSymbol,			/* 25 keypad * */
+     XK_grave, XK_asciitilde,			/* 26 keypad ` ~ */
+     XK_KP_Equal, XK_bar,			/* 27 keypad = (and |) */
+     XK_KP_Divide, XK_backslash,		/* 28 keypad / (and \) */
+     HOLE,					/* 29 */
+     XK_Return, NoSymbol,			/* 2a return */
+     XK_apostrophe, XK_quotedbl,		/* 2b ' " */
+     XK_semicolon, XK_colon,			/* 2c ; : */
+     XK_L, NoSymbol,				/* 2d l */
+     XK_comma, XK_less,				/* 2e , < */
+     XK_period, XK_greater,			/* 2f . > */
+     XK_slash, XK_question,			/* 30 / ? */
+     XK_Z, NoSymbol,				/* 31 z */
+     XK_X, NoSymbol,				/* 32 x */
+     XK_C, NoSymbol,				/* 33 c */
+     XK_V, NoSymbol,				/* 34 v */
+     XK_B, NoSymbol,				/* 35 b */
+     XK_M, NoSymbol,				/* 36 m */
+     XK_N, NoSymbol,				/* 37 n */
+     XK_space, NoSymbol,			/* 38 space */
+     XK_A, NoSymbol,				/* 39 a */
+     XK_S, NoSymbol,				/* 3a s */
+     XK_D, NoSymbol,				/* 3b d */
+     XK_F, NoSymbol,				/* 3c f */
+     XK_G, NoSymbol,				/* 3d g */
+     XK_K, NoSymbol,				/* 3e k */
+     XK_J, NoSymbol,				/* 3f j */
+     XK_H, NoSymbol,				/* 40 h */
+     XK_Tab, NoSymbol,				/* 41 tab */
+     XK_Q, NoSymbol,				/* 42 q */
+     XK_W, NoSymbol,				/* 43 w */
+     XK_E, NoSymbol,				/* 44 e */
+     XK_R, NoSymbol,				/* 45 r */
+     XK_U, NoSymbol,				/* 46 u */
+     XK_Y, NoSymbol,				/* 47 y */
+     XK_T, NoSymbol,				/* 48 t */
+     XK_Escape, NoSymbol,			/* 49 esc */
+     XK_1, XK_exclam,				/* 4a 1 ! */
+     XK_2, XK_at,				/* 4b 2 @ */
+     XK_3, XK_numbersign,			/* 4c 3 # */
+     XK_4, XK_dollar,				/* 4d 4 $ */
+     XK_7, XK_ampersand,			/* 4e 7 & */
+     XK_6, XK_asciicircum,			/* 4f 6 ^ */
+     XK_5, XK_percent,				/* 50 5 % */
+     XK_Control_L, NoSymbol,			/* 51, fake control */
+     XK_Shift_L, NoSymbol,			/* 52, fake left shift */
+     XK_Shift_R, NoSymbol,			/* 53, fake right shift */
+     XK_Meta_L, NoSymbol,			/* 54, fake left command */
+     XK_Meta_R, NoSymbol,			/* 55, fake right command */
+     XK_Alt_L, NoSymbol,			/* 56, fake left alt */
+     XK_Alt_R, NoSymbol,			/* 57, fake right alt */ };
+static KeySymsRec keysyms
+ = { &keysymvec[0], 0x01+KEYCODE_OFFSET, 0x57+KEYCODE_OFFSET, 2 };
+
+#define EV_ID_SHIFT 16
+#define EV_ID_KB 0x1000
+#define EV_KB_KEY 0x8000
+#define EV_KB_MOD_CONTROL     0x0100
+#define EV_KB_MOD_L_SHIFT     0x0200
+#define EV_KB_MOD_R_SHIFT     0x0400
+#define EV_KB_MOD_L_COMMAND   0x0800
+#define EV_KB_MOD_R_COMMAND   0x1000
+#define EV_KB_MOD_L_ALTERNATE 0x2000
+#define EV_KB_MOD_R_ALTERNATE 0x4000
+#define EV_KB_MODIFIERS       0x7f00
+#define EV_KB_UPDN 0x0080
+#define EV_KB_DN   0x0000
+#define EV_KB_UP   0x0080
+#define EV_KB_KEYCODE 0x007f
+#define EV_ID_MS 0x0100
+#define EV_MS_XSHIFT 1
+#define EV_MS_YSHIFT 9
+#define EV_MS_DELTAMASK 0x7f
+#define EV_MS_DELTASIGN 0x40
+#define EV_MS_BUTTON_L 0x0001
+#define EV_MS_BUTTON_L_UP 0x0001
+#define EV_MS_BUTTON_L_DN 0x0000
+#define EV_MS_BUTTON_R 0x0100
+#define EV_MS_BUTTON_R_UP 0x0100
+#define EV_MS_BUTTON_R_DN 0x0000
+
+/* pseudo-keys corresponding to modifiers,
+   keycode elements _not_ offset by KEYCODE_OFFSET */
+static unsigned int fakekeyvec[][2]
+ = { { EV_KB_MOD_CONTROL,     0x51 },
+     { EV_KB_MOD_L_SHIFT,     0x52 },
+     { EV_KB_MOD_R_SHIFT,     0x53 },
+     { EV_KB_MOD_L_COMMAND,   0x54 },
+     { EV_KB_MOD_R_COMMAND,   0x55 },
+     { EV_KB_MOD_L_ALTERNATE, 0x56 },
+     { EV_KB_MOD_R_ALTERNATE, 0x57 } };
+#define NFAKEKEYS (sizeof(fakekeyvec)/sizeof(fakekeyvec[0]))
+
+typedef struct kbstate KBSTATE;
+typedef struct msstate MSSTATE;
+typedef struct fbstate FBSTATE;
+
+struct kbstate {
+  unsigned long int last;
+  } ;
+
+struct msstate {
+  unsigned long int last;
+  } ;
+
+struct fbstate {
+  Bool (*close_screen)(int, ScreenPtr);
+  } ;
+
+static KBSTATE kb_private;
+static MSSTATE ms_private;
+static FBSTATE fb_private;
+static ColormapPtr installed_map;
+static volatile int gotsigio;
+
+static void sigio_handler(int sig UNUSED)
+{
+ gotsigio = 1;
+}
+
+void OsVendorInit(void)
+{
+ static int inited = 0;
+ int v;
+
+ if (! inited)
+  { signal(SIGIO,sigio_handler);
+    gotsigio = 1;
+    nkfd = open("/dev/nk",O_RDWR,0);
+    if (nkfd < 0) FatalError("Cannot open /dev/nk: %s\n",strerror(errno));
+    v = fcntl(nkfd,F_GETFL,0);
+    if (v >= 0) v = fcntl(nkfd,F_SETFL,v|O_NONBLOCK|O_ASYNC);
+    if (v < 0) FatalError("Cannot enable NONBLOCK and ASYNC on /dev/nk: %s\n",strerror(errno));
+    if (fcntl(nkfd,F_SETOWN,getpgrp()) < 0) FatalError("Cannot F_SETOWN /dev/nk: %s\n",strerror(errno));
+    fbfd = open("/dev/ttyE0",O_RDWR,0);
+    if (fbfd < 0) FatalError("Cannot open /dev/ttyE0: %s\n",strerror(errno));
+    installed_map = 0;
+    inited = 1;
+  }
+}
+
+static Bool pointer_off_screen(ScreenPtr *scrp UNUSED, int *x UNUSED, int *y UNUSED)
+{
+ return(PointerConfinedToScreen());
+}
+
+static void pointer_cross_screen(ScreenPtr scr UNUSED, Bool enterleave UNUSED)
+{
+}
+
+static void pointer_warp_cursor(ScreenPtr scr, int x, int y)
+{
+ miPointerWarpCursor(scr,x,y);
+}
+
+static void block_handler(int nscr UNUSED, pointer pbdata UNUSED, struct timeval **tvpp, pointer fdsp)
+{
+ static struct timeval ztv = { 0, 0 };
+
+ if (gotsigio)
+  { *tvpp = &ztv;
+    return;
+  }
+ FD_SET(nkfd,(fd_set *)fdsp);
+}
+
+static void keystroke(int keycode, int updn)
+{
+ xEvent e;
+
+ keycode += KEYCODE_OFFSET;
+ if ((keycode < keysyms.minKeyCode) || (keycode > keysyms.maxKeyCode)) return;
+ e.u.keyButtonPointer.time = nowms;
+ e.u.u.type = ((updn & EV_KB_UPDN) == EV_KB_UP) ? KeyRelease : KeyPress;
+ e.u.u.detail = keycode;
+ mieqEnqueue(&e);
+}
+
+static void mouse_button(int b, int evtype)
+{
+ xEvent e;
+
+ e.u.u.detail = b;
+ e.u.u.type = evtype;
+ e.u.keyButtonPointer.time = nowms;
+ mieqEnqueue(&e);
+}
+
+static void mouse_delta(int dx, int dy)
+{
+ DeviceIntPtr dev;
+ PtrCtrl *pc;
+
+ static int process_delta(int d)
+  { int neg;
+    if (d & EV_MS_DELTASIGN)
+     { neg = 1;
+       d = EV_MS_DELTAMASK+1 - d;
+     }
+    else
+     { neg = 0;
+     }
+    if (d > pc->threshold) d = pc->threshold + (((d - pc->threshold) * pc->num) / pc->den);
+    /* Note that motion in each dimension is reversed from the X
+       conventions; having neg "backwards" here is where we compensate. */
+    return(neg?d:-d);
+  }
+
+ dx &= EV_MS_DELTAMASK;
+ dy &= EV_MS_DELTAMASK;
+ if (!dx && !dy) return;
+ dev = (DeviceIntPtr) LookupPointerDevice();
+ pc = &dev->ptrfeed->ctrl;
+ miPointerDeltaCursor(process_delta(dx),process_delta(dy),nowms);
+}
+
+static void process_event(unsigned int ev)
+{
+ switch (ev >> EV_ID_SHIFT)
+  { case EV_ID_KB:
+	{ unsigned int modchg;
+	  unsigned int bit;
+	  int i;
+	  modchg = (kb_private.last ^ ev) & EV_KB_MODIFIERS;
+	  while (modchg)
+	   { bit = modchg & ~(modchg-1);
+	     for (i=0;i<NFAKEKEYS;i++)
+	      { if (fakekeyvec[i][0] == bit)
+		 { keystroke(fakekeyvec[i][1],(ev&bit)?EV_KB_DN:EV_KB_UP);
+		   break;
+		 }
+	      }
+	     modchg &= ~bit;
+	   }
+	  kb_private.last = ev;
+	  if (ev & EV_KB_KEY) keystroke(ev&EV_KB_KEYCODE,ev&EV_KB_UPDN);
+	}
+       break;
+    case EV_ID_MS:
+       if ((ms_private.last ^ ev) & EV_MS_BUTTON_L)
+	{ switch (ev & EV_MS_BUTTON_L)
+	   { case EV_MS_BUTTON_L_UP:
+		mouse_button(1,ButtonRelease);
+		break;
+	     case EV_MS_BUTTON_L_DN:
+		mouse_button(1,ButtonPress);
+		break;
+	   }
+	}
+       if ((ms_private.last ^ ev) & EV_MS_BUTTON_R)
+	{ switch (ev & EV_MS_BUTTON_R)
+	   { case EV_MS_BUTTON_R_UP:
+		mouse_button(2,ButtonRelease);
+		break;
+	     case EV_MS_BUTTON_R_DN:
+		mouse_button(2,ButtonPress);
+		break;
+	   }
+	}
+       mouse_delta(ev>>EV_MS_XSHIFT,ev>>EV_MS_YSHIFT);
+       ms_private.last = ev;
+       break;
+  }
+}
+
+static void read_input_events(void)
+{
+ unsigned int evs[32];
+ int n;
+ int i;
+
+ n = read(nkfd,&evs[0],sizeof(evs));
+ if (n < 0)
+  { if (errno == EWOULDBLOCK) return;
+    Error("Reading keyboard/mouse");
+    FatalError("Could not read the keyboard/mouse");
+  }
+ if (n == 0)
+  { Error("Unexpected EOF from keyboard/mouse\n");
+    FatalError("Could not read the keyboard/mouse");
+  }
+ if (n % sizeof(unsigned int))
+  { Error("Size wrong reading from keyboard/mouse\n");
+    FatalError("Could not read the keyboard/mouse");
+  }
+ n /= sizeof(unsigned int);
+ gettimeofday(&now,0);
+ nowms = (now.tv_usec / 1000) + (now.tv_sec * 1000);
+ for (i=0;i<n;i++) process_event(evs[i]);
+}
+
+static void wakeup_handler(int scrno UNUSED, pointer wdata UNUSED, unsigned long int selrv UNUSED, pointer fdsp)
+{
+ gotsigio = 0;
+ read_input_events();
+}
+
+static void set_mapped_mode(int on)
+{
+ int m;
+
+ m = on ? WSDISPLAYIO_MODE_MAPPED : WSDISPLAYIO_MODE_EMUL;
+ ioctl(fbfd,WSDISPLAYIO_SMODE,&m);
+}
+
+static Bool close_screen(int inx, ScreenPtr scr)
+{
+ FBSTATE *priv;
+
+ priv = scr->devPrivates[inx].ptr;
+ set_mapped_mode(0);
+ scr->CloseScreen = priv->close_screen;
+ xfree(priv);
+ return((*scr->CloseScreen)(inx,scr));
+}
+
+static void install_colormap(ColormapPtr cmap)
+{
+ if (cmap != installed_map)
+  { if (installed_map != 0) WalkTree(cmap->pScreen,TellLostMap,&installed_map->mid);
+    installed_map = cmap;
+    WalkTree(cmap->pScreen,TellGainedMap,&cmap->mid);
+  }
+}
+
+static void uninstall_colormap(ColormapPtr cmap)
+{
+ if (cmap == installed_map)
+  { if (cmap->mid != cmap->pScreen->defColormap)
+     { (*cmap->pScreen->InstallColormap)((ColormapPtr)LookupIDByType(cmap->pScreen->defColormap,RT_COLORMAP));
+     }
+  }
+}
+
+static int list_colormaps(ScreenPtr scr, Colormap *maps)
+{
+ *maps = installed_map->mid;
+ return(1);
+}
+
+static void store_colors(ColormapPtr cm UNUSED, int n UNUSED, xColorItem *cols UNUSED)
+{
+}
+
+static Bool initialize_colormap(ColormapPtr map)
+{
+ map->red[0].co.local.red = 0xffff;
+ map->red[0].co.local.green = 0xffff;
+ map->red[0].co.local.blue = 0xffff;
+ map->red[1].co.local.red = 0xaaaa;
+ map->red[1].co.local.green = 0xaaaa;
+ map->red[1].co.local.blue = 0xaaaa;
+ map->red[2].co.local.red = 0x5555;
+ map->red[2].co.local.green = 0x5555;
+ map->red[2].co.local.blue = 0x5555;
+ map->red[3].co.local.red = 0x0000;
+ map->red[3].co.local.green = 0x0000;
+ map->red[3].co.local.blue = 0x0000;
+ return(TRUE);
+}
+
+static Bool save_screen(ScreenPtr scr UNUSED, int on UNUSED)
+{
+ return(FALSE);
+}
+
+static Bool fbinit(int scrno, ScreenPtr scr, int ac, char **av)
+{
+ static miPointerScreenFuncRec pointer_screen_ops
+  = { &pointer_off_screen,
+      &pointer_cross_screen,
+      &pointer_warp_cursor };
+ FBSTATE *priv;
+ VisualPtr vis;
+ ColormapPtr cmap;
+
+ if (generation != serverGeneration)
+  { inx = AllocateScreenPrivateIndex();
+    if (inx < 0) return(FALSE);
+    generation = serverGeneration;
+  }
+ if (scrno != 0) return(FALSE);
+ priv = (void *) xalloc(sizeof(FBSTATE)); /* why the hell isn't it void *?? */
+ scr->devPrivates[inx].ptr = priv;
+ if (! vram)
+  { set_mapped_mode(1);
+    vram = mmap(0,(1152*832*2)/8,PROT_READ|PROT_WRITE,MAP_SHARED,fbfd,0);
+    if (vram == MAP_FAILED)
+     { Error("mapping framebuffer");
+       return(FALSE);
+     }
+  }
+ if (! cfbSetupScreen(scr,vram,1120,832,90,90,1152)) return(FALSE);
+ scr->CreateColormap = initialize_colormap;
+ scr->InstallColormap = install_colormap;
+ scr->UninstallColormap = uninstall_colormap;
+ scr->ListInstalledColormaps = list_colormaps;
+ scr->StoreColors = store_colors;
+ cfbSetVisualTypes(2,1<<StaticGray,2);
+ if (! cfbFinishScreenInit(scr,vram,1120,832,90,90,1152)) return(FALSE);
+ priv->close_screen = scr->CloseScreen;
+ scr->CloseScreen = close_screen;
+ scr->SaveScreen = save_screen;
+#ifdef XKB
+ if (noXkbExtension)
+#endif
+  { scr->BlockHandler = block_handler;
+    scr->WakeupHandler = wakeup_handler;
+  }
+ scr->blackPixel = 3;
+ scr->whitePixel = 0;
+ miDCInitialize(scr,&pointer_screen_ops);
+ for (vis=scr->visuals;vis->vid!=scr->rootVisual;vis++) ;
+ if (CreateColormap(scr->defColormap,scr,vis,&cmap,AllocAll,0) != Success) return(FALSE);
+ (*scr->InstallColormap)(cmap);
+ return(TRUE);
+}
+
+void InitOutput(ScreenInfo *info, int ac, char **av)
+{
+ if (! monitorResolution) monitorResolution = 90;
+ info->imageByteOrder = IMAGE_BYTE_ORDER;
+ info->bitmapScanlineUnit = BITMAP_SCANLINE_UNIT;
+ info->bitmapScanlinePad = BITMAP_SCANLINE_PAD;
+ info->bitmapBitOrder = BITMAP_BIT_ORDER;
+ info->formats[0].depth = 1;
+ info->formats[0].bitsPerPixel = 1;
+ info->formats[0].scanlinePad = BITMAP_SCANLINE_PAD;
+ info->formats[1].depth = 2;
+ info->formats[1].bitsPerPixel = 2;
+ info->formats[1].scanlinePad = BITMAP_SCANLINE_PAD;
+ /* Fsck.  dix seems to assume there is at most one format per depth!
+    (It's got tables indexed [depth].) */
+#if 0
+ info->formats[2].depth = 2;
+ info->formats[2].bitsPerPixel = 4;
+ info->formats[2].scanlinePad = BITMAP_SCANLINE_PAD;
+ info->formats[3].depth = 2;
+ info->formats[3].bitsPerPixel = 8;
+ info->formats[3].scanlinePad = BITMAP_SCANLINE_PAD;
+#endif
+ info->numPixmapFormats = 2 /*4*/;
+ AddScreen(fbinit,ac,av);
+}
+
+/* I have no idea what the fourth arg is. */
+static void bellproc(int pct UNUSED, DeviceIntPtr dev UNUSED, pointer ctrl UNUSED, int ignore UNUSED)
+{
+}
+
+static void kbctl(DeviceIntPtr dev UNUSED, KeybdCtrl *ctl UNUSED)
+{
+ /* ctl->click for keyboard click, ctl->leds for LEDs */
+}
+
+static int kbproc(DeviceIntPtr device, int what)
+{
+ DevicePtr kb;
+ KBSTATE *priv;
+
+ kb = (DevicePtr) device;
+ switch (what)
+  { case DEVICE_INIT:
+       if (kb != LookupKeyboardDevice())
+	{ ErrorF("Cannot open non-system keyboard\n");
+	  return(!Success);
+	}
+       /*autorep_key = -1;*/
+       kb->devicePrivate = &kb_private;
+       kb->on = FALSE;
+#ifdef XKB
+       if (noXkbExtension)
+	{
+#endif
+	  InitKeyboardDeviceStruct(kb,&keysyms,&modmap[0],bellproc,kbctl);
+#ifdef XKB
+	}
+       else
+#ifndef XKBBUFSIZE
+#define XKBBUFSIZE 64
+#endif
+	{ XkbComponentNamesRec names;
+	  names.keymap = 0;
+	  names.compat = "compat/complete";
+	  names.types = "types/complete";
+	  names.keycodes = 0;
+	  names.geometry = 0;
+	  names.symbols = 0;
+	  XkbInitKeyboardDeviceStruct(device,&names,&keysyms,&modmap[0],bellproc,kbctl);
+	}
+#endif
+       break;
+    case DEVICE_ON:
+       priv = kb->devicePrivate;
+       AddEnabledDevice(nkfd);
+       kb->on = TRUE;
+       break;
+    case DEVICE_CLOSE:
+    case DEVICE_OFF:
+       priv = kb->devicePrivate;
+       RemoveEnabledDevice(nkfd);
+       kb->on = FALSE;
+       break;
+    default:
+       FatalError("Unknown keyboard operation\n");
+       break;
+  }
+ return(Success);
+}
+
+static void msctl(DeviceIntPtr dev UNUSED, PtrCtrl *ctl UNUSED)
+{
+}
+
+static int msproc(DeviceIntPtr device, int what)
+{
+ DevicePtr ms;
+ BYTE map[3];
+
+ ms = (DevicePtr) device;
+ switch (what)
+  { case DEVICE_INIT:
+       if (ms != LookupPointerDevice())
+	{ ErrorF("Cannot open non-system mouse");
+	  return(!Success);
+	}
+       ms->devicePrivate = &ms_private;
+       ms->on = FALSE;
+       map[1] = 1;
+       map[2] = 2;
+       InitPointerDeviceStruct(ms,&map[0],2,miPointerGetMotionEvents,msctl,miPointerGetMotionBufferSize());
+       break;
+    case DEVICE_ON:
+       ms_private.last = 0;
+       ms->on = TRUE;
+       break;
+    case DEVICE_CLOSE:
+       ms->on = FALSE;
+       break;
+    case DEVICE_OFF:
+       ms->on = FALSE;
+       break;
+  }
+ return(Success);
+}
+
+void InitInput(int ac, char **av)
+{
+ DevicePtr kdp;
+ DevicePtr mdp;
+
+ kdp = AddInputDevice(kbproc,TRUE);
+ mdp = AddInputDevice(msproc,TRUE);
+ if (!kdp || !mdp) FatalError("failed to create input devices in InitInput");
+ RegisterPointerDevice(mdp);
+ RegisterKeyboardDevice(kdp);
+ miRegisterPointerDevice(screenInfo.screens[0],mdp);
+ mieqInit(kdp,mdp);
+}
+
+#ifdef DPMSExtension
+
+void DPMSSet(int lev)
+{
+}
+
+int DPMSGet(int *lp)
+{
+ return(-1);
+}
+
+Bool DPMSSupported(void)
+{
+ return(FALSE);
+}
+
+#endif
+
+void AbortDDX(void)
+{
+}
+
+void ddxGiveUp(void)
+{
+}
+
+int ddxProcessArgument(int ac, char **av, int i)
+{
+#ifndef XKB
+ if (! strcmp(argv[i],"-ar1"))
+  { if (++i >= argc) UseMsg();
+    ar1 = atoi(argv[i]) * 1000;
+    return(2);
+  }
+ if (! strcmp(argv[i],"-ar2"))
+  { if (++i >= argc) UseMsg();
+    ar2 = atoi(argv[i]) * 1000;
+    return(2);
+  }
+#endif
+ return(0);
+}
+
+void ddxUseMsg(void)
+{
+#ifndef XKB
+ ErrorF("-ar1 int            set autorepeat initiate time\n");
+ ErrorF("-ar2 int            set autorepeat interval time\n");
+#endif
+}
+
+Bool LegalModifier(unsigned int key UNUSED, DevicePtr dev UNUSED)
+{
+ return(TRUE);
+}
+
+void ProcessInputEvents(void)
+{
+ mieqProcessInputEvents();
+ miPointerUpdate();
+}
