--- OLD/xc/lib/X11/Xlib.h	Thu Jan  1 00:00:00 1970
+++ NEW/xc/lib/X11/Xlib.h	Thu Jan  1 00:00:00 1970
@@ -141,7 +141,12 @@
 typedef struct _XExtData {
 	int number;		/* number returned by XRegisterExtension */
 	struct _XExtData *next;	/* next item on list of data for structure */
+#if NeedFunctionPrototypes
+	int (*free_private)(struct _XExtData *);
+				/* called to free private storage */
+#else
 	int (*free_private)();	/* called to free private storage */
+#endif
 	XPointer private_data;	/* data private to this extension. */
 } XExtData;
 
@@ -243,7 +248,12 @@
  * by application code.
  */
 
-struct _XDisplay;		/* Forward declare before use for C++ */
+/* Forward declare _Xdisplay first. */
+#ifdef XLIB_ILLEGAL_ACCESS
+#define _XDisplay _XPrivDisplay_
+#endif
+struct _XDisplay;
+typedef struct _XDisplay Display;
 
 typedef struct {
 	XExtData *ext_data;	/* hook for extension to hang data */
@@ -355,14 +365,15 @@
     unsigned long blue_mask;
     XPointer obdata;		/* hook for the object routines to hang on */
     struct funcs {		/* image manipulation routines */
-	struct _XImage *(*create_image)();
 #if NeedFunctionPrototypes
+	struct _XImage *(*create_image)(Display *, Visual *, unsigned int, int, int, char *, unsigned int, unsigned int, int, int);
 	int (*destroy_image)        (struct _XImage *);
 	unsigned long (*get_pixel)  (struct _XImage *, int, int);
 	int (*put_pixel)            (struct _XImage *, int, int, unsigned long);
 	struct _XImage *(*sub_image)(struct _XImage *, int, int, unsigned int, unsigned int);
 	int (*add_pixel)            (struct _XImage *, long);
 #else
+	struct _XImage *(*create_image)();
 	int (*destroy_image)();
 	unsigned long (*get_pixel)();
 	int (*put_pixel)();
@@ -462,17 +473,11 @@
  * The contents of this structure are implementation dependent.
  * A Display should be treated as opaque by application code.
  */
-#ifndef XLIB_ILLEGAL_ACCESS
-typedef struct _XDisplay Display;
-#endif
 
 struct _XPrivate;		/* Forward declare before use for C++ */
 struct _XrmHashBucketRec;
 
-typedef struct 
-#ifdef XLIB_ILLEGAL_ACCESS
-_XDisplay
-#endif
+typedef struct _XPrivDisplay_
 {
 	XExtData *ext_data;	/* hook for extension to hang data */
 	struct _XPrivate *private1;
@@ -485,7 +490,11 @@
 	XID private4;
 	XID private5;
 	int private6;
+#if NeedFunctionPrototypes
+	XID (*resource_alloc)(Display *);/* allocator function */
+#else
 	XID (*resource_alloc)();/* allocator function */
+#endif
 	int byte_order;		/* screen byte order, LSBFirst, MSBFirst */
 	int bitmap_unit;	/* padding and data requirements */
 	int bitmap_pad;		/* padding requirements on bitmaps */
@@ -504,7 +513,11 @@
 	XPointer private14;
 	unsigned max_request_size; /* maximum number 32 bit words in request*/
 	struct _XrmHashBucketRec *db;
+#if NeedFunctionPrototypes
+	int (*private15)(Display *);
+#else
 	int (*private15)();
+#endif
 	char *display_name;	/* "host:display" string used on this connect*/
 	int default_screen;	/* default screen for operations */
 	int nscreens;		/* number of screens on this server*/
@@ -518,11 +531,7 @@
 	int private19;
 	char *xdefaults;	/* contents of defaults from server */
 	/* there is more to this structure, but it is private to Xlib */
-}
-#ifdef XLIB_ILLEGAL_ACCESS
-Display, 
-#endif
-*_XPrivDisplay;
+} *_XPrivDisplay;
 
 #if NeedFunctionPrototypes	/* prototypes require event type definitions */
 #undef _XEVENT_
@@ -1033,7 +1042,8 @@
     XRectangle      max_logical_extent;
 } XFontSetExtents;
 
-typedef void (*XOMProc)();
+/* What the _hell_ is this thing?  In particular, what's its prototype? */
+/* typedef void (*XOMProc)(); */
 
 typedef struct _XOM *XOM;
 typedef struct _XOC *XOC, *XFontSet;
@@ -1087,7 +1097,13 @@
     char **font_name_list;
 } XOMFontInfo;
 
+#if NeedFunctionPrototypes
+/* is this really the right prototype? */
+struct _XIC; /* forward */
+typedef void (*XIMProc)(XPointer, XPointer, XPointer);
+#else
 typedef void (*XIMProc)();
+#endif
 
 typedef struct _XIM *XIM;
 typedef struct _XIC *XIC;
@@ -1492,17 +1508,25 @@
     Display*		/* display */,
     Bool		/* onoff */
 #endif
-))();
+))(
+#if NeedFunctionPrototypes
+  Display *
+#endif
+);
 extern int (*XSetAfterFunction(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int (*) (
-#if NeedNestedPrototypes
+/*#if NeedNestedPrototypes*/
 	     Display*	/* display */
-#endif
+/*#endif*/
             )		/* procedure */
 #endif
-))();
+))(
+#ifdef NeedFunctionPrototypes
+  Display *
+#endif
+);
 extern Atom XInternAtom(
 #if NeedFunctionPrototypes
     Display*		/* display */,
@@ -2049,7 +2073,7 @@
     char**		/* list */
 #endif
 );
-extern XSetTransientForHint(
+extern void XSetTransientForHint(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2059,20 +2083,20 @@
 
 /* The following are given in alphabetical order */
 
-extern XActivateScreenSaver(
+extern void XActivateScreenSaver(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XAddHost(
+extern void XAddHost(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XHostAddress*	/* host */
 #endif
 );
 
-extern XAddHosts(
+extern void XAddHosts(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XHostAddress*	/* hosts */,
@@ -2080,14 +2104,14 @@
 #endif
 );
 
-extern XAddToExtensionList(
+extern void XAddToExtensionList(
 #if NeedFunctionPrototypes
     struct _XExtData**	/* structure */,
     XExtData*		/* ext_data */
 #endif
 );
 
-extern XAddToSaveSet(
+extern void XAddToSaveSet(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
@@ -2140,7 +2164,7 @@
 #endif
 );
 
-extern XAllowEvents(
+extern void XAllowEvents(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* event_mode */,
@@ -2148,19 +2172,19 @@
 #endif
 );
 
-extern XAutoRepeatOff(
+extern void XAutoRepeatOff(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XAutoRepeatOn(
+extern void XAutoRepeatOn(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XBell(
+extern void XBell(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* percent */
@@ -2191,7 +2215,7 @@
 #endif
 );
 
-extern XChangeActivePointerGrab(
+extern void XChangeActivePointerGrab(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     unsigned int	/* event_mask */,
@@ -2200,7 +2224,7 @@
 #endif
 );
 
-extern XChangeGC(
+extern void XChangeGC(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -2209,7 +2233,7 @@
 #endif
 );
 
-extern XChangeKeyboardControl(
+extern void XChangeKeyboardControl(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     unsigned long	/* value_mask */,
@@ -2217,7 +2241,7 @@
 #endif
 );
 
-extern XChangeKeyboardMapping(
+extern void XChangeKeyboardMapping(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* first_keycode */,
@@ -2227,7 +2251,7 @@
 #endif
 );
 
-extern XChangePointerControl(
+extern void XChangePointerControl(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Bool		/* do_accel */,
@@ -2238,7 +2262,7 @@
 #endif
 );
 
-extern XChangeProperty(
+extern void XChangeProperty(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2251,7 +2275,7 @@
 #endif
 );
 
-extern XChangeSaveSet(
+extern void XChangeSaveSet(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2259,7 +2283,7 @@
 #endif
 );
 
-extern XChangeWindowAttributes(
+extern void XChangeWindowAttributes(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2317,7 +2341,7 @@
 #endif
 );
 
-extern XCirculateSubwindows(
+extern void XCirculateSubwindows(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2325,21 +2349,21 @@
 #endif
 );
 
-extern XCirculateSubwindowsDown(
+extern void XCirculateSubwindowsDown(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XCirculateSubwindowsUp(
+extern void XCirculateSubwindowsUp(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XClearArea(
+extern void XClearArea(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2351,20 +2375,20 @@
 #endif
 );
 
-extern XClearWindow(
+extern void XClearWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XCloseDisplay(
+extern void XCloseDisplay(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XConfigureWindow(
+extern void XConfigureWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2379,7 +2403,7 @@
 #endif
 );
 
-extern XConvertSelection(
+extern void XConvertSelection(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Atom		/* selection */,
@@ -2390,7 +2414,7 @@
 #endif
 );
 
-extern XCopyArea(
+extern void XCopyArea(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* src */,
@@ -2405,7 +2429,7 @@
 #endif
 );
 
-extern XCopyGC(
+extern void XCopyGC(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* src */,
@@ -2414,7 +2438,7 @@
 #endif
 );
 
-extern XCopyPlane(
+extern void XCopyPlane(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* src */,
@@ -2449,7 +2473,7 @@
 #endif
 );
 
-extern XDefineCursor(
+extern void XDefineCursor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2457,7 +2481,7 @@
 #endif
 );
 
-extern XDeleteProperty(
+extern void XDeleteProperty(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -2465,14 +2489,14 @@
 #endif
 );
 
-extern XDestroyWindow(
+extern void XDestroyWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XDestroySubwindows(
+extern void XDestroySubwindows(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
@@ -2491,7 +2515,7 @@
 #endif
 );
 
-extern XDisableAccessControl(
+extern void XDisableAccessControl(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
@@ -2519,7 +2543,7 @@
 #endif
 );
 
-extern XDisplayKeycodes(
+extern void XDisplayKeycodes(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int*		/* min_keycodes_return */,
@@ -2548,7 +2572,7 @@
 #endif
 );
 
-extern XDrawArc(
+extern void XDrawArc(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2562,7 +2586,7 @@
 #endif
 );
 
-extern XDrawArcs(
+extern void XDrawArcs(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2572,7 +2596,7 @@
 #endif
 );
 
-extern XDrawImageString(
+extern void XDrawImageString(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2584,7 +2608,7 @@
 #endif
 );
 
-extern XDrawImageString16(
+extern void XDrawImageString16(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2596,7 +2620,7 @@
 #endif
 );
 
-extern XDrawLine(
+extern void XDrawLine(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2608,7 +2632,7 @@
 #endif
 );
 
-extern XDrawLines(
+extern void XDrawLines(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2619,7 +2643,7 @@
 #endif
 );
 
-extern XDrawPoint(
+extern void XDrawPoint(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2629,7 +2653,7 @@
 #endif
 );
 
-extern XDrawPoints(
+extern void XDrawPoints(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2640,7 +2664,7 @@
 #endif
 );
 
-extern XDrawRectangle(
+extern void XDrawRectangle(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2652,7 +2676,7 @@
 #endif
 );
 
-extern XDrawRectangles(
+extern void XDrawRectangles(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2662,7 +2686,7 @@
 #endif
 );
 
-extern XDrawSegments(
+extern void XDrawSegments(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2672,7 +2696,7 @@
 #endif
 );
 
-extern XDrawString(
+extern void XDrawString(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2684,7 +2708,7 @@
 #endif
 );
 
-extern XDrawString16(
+extern void XDrawString16(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2696,7 +2720,7 @@
 #endif
 );
 
-extern XDrawText(
+extern void XDrawText(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2708,7 +2732,7 @@
 #endif
 );
 
-extern XDrawText16(
+extern void XDrawText16(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2720,7 +2744,7 @@
 #endif
 );
 
-extern XEnableAccessControl(
+extern void XEnableAccessControl(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
@@ -2741,7 +2765,7 @@
 #endif
 );
 
-extern XFillArc(
+extern void XFillArc(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2755,7 +2779,7 @@
 #endif
 );
 
-extern XFillArcs(
+extern void XFillArcs(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2765,7 +2789,7 @@
 #endif
 );
 
-extern XFillPolygon(
+extern void XFillPolygon(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2777,7 +2801,7 @@
 #endif
 );
 
-extern XFillRectangle(
+extern void XFillRectangle(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2789,7 +2813,7 @@
 #endif
 );
 
-extern XFillRectangles(
+extern void XFillRectangles(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -2799,33 +2823,33 @@
 #endif
 );
 
-extern XFlush(
+extern void XFlush(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XForceScreenSaver(
+extern void XForceScreenSaver(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* mode */
 #endif
 );
 
-extern XFree(
+extern void XFree(
 #if NeedFunctionPrototypes
     void*		/* data */
 #endif
 );
 
-extern XFreeColormap(
+extern void XFreeColormap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */
 #endif
 );
 
-extern XFreeColors(
+extern void XFreeColors(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */,
@@ -2835,27 +2859,27 @@
 #endif
 );
 
-extern XFreeCursor(
+extern void XFreeCursor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Cursor		/* cursor */
 #endif
 );
 
-extern XFreeExtensionList(
+extern void XFreeExtensionList(
 #if NeedFunctionPrototypes
     char**		/* list */    
 #endif
 );
 
-extern XFreeFont(
+extern void XFreeFont(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XFontStruct*	/* font_struct */
 #endif
 );
 
-extern XFreeFontInfo(
+extern void XFreeFontInfo(
 #if NeedFunctionPrototypes
     char**		/* names */,
     XFontStruct*	/* free_info */,
@@ -2863,32 +2887,32 @@
 #endif
 );
 
-extern XFreeFontNames(
+extern void XFreeFontNames(
 #if NeedFunctionPrototypes
     char**		/* list */
 #endif
 );
 
-extern XFreeFontPath(
+extern void XFreeFontPath(
 #if NeedFunctionPrototypes
     char**		/* list */
 #endif
 );
 
-extern XFreeGC(
+extern void XFreeGC(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */
 #endif
 );
 
-extern XFreeModifiermap(
+extern void XFreeModifiermap(
 #if NeedFunctionPrototypes
     XModifierKeymap*	/* modmap */
 #endif
 );
 
-extern XFreePixmap(
+extern void XFreePixmap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Pixmap		/* pixmap */
@@ -2913,7 +2937,7 @@
 #endif
 );
 
-extern XGetErrorDatabaseText(
+extern void XGetErrorDatabaseText(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     _Xconst char*	/* name */,
@@ -2924,7 +2948,7 @@
 #endif
 );
 
-extern XGetErrorText(
+extern void XGetErrorText(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* code */,
@@ -2972,7 +2996,7 @@
 #endif
 );
 
-extern XGetInputFocus(
+extern void XGetInputFocus(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window*		/* focus_return */,
@@ -2980,14 +3004,14 @@
 #endif
 );
 
-extern XGetKeyboardControl(
+extern void XGetKeyboardControl(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XKeyboardState*	/* values_return */
 #endif
 );
 
-extern XGetPointerControl(
+extern void XGetPointerControl(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int*		/* accel_numerator_return */,
@@ -3004,7 +3028,7 @@
 #endif
 );
 
-extern XGetScreenSaver(
+extern void XGetScreenSaver(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int*		/* timeout_return */,
@@ -3047,7 +3071,7 @@
 #endif
 );
 
-extern XGrabButton(
+extern void XGrabButton(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     unsigned int	/* button */,
@@ -3062,7 +3086,7 @@
 #endif
 );
 
-extern XGrabKey(
+extern void XGrabKey(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* keycode */,
@@ -3099,7 +3123,7 @@
 #endif
 );
 
-extern XGrabServer(
+extern void XGrabServer(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
@@ -3117,7 +3141,7 @@
 #endif
 );
 
-extern XIfEvent(
+extern void XIfEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XEvent*		/* event_return */,
@@ -3138,7 +3162,7 @@
 #endif
 );
 
-extern XInstallColormap(
+extern void XInstallColormap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */
@@ -3152,7 +3176,7 @@
 #endif
 );
 
-extern XKillClient(
+extern void XKillClient(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XID			/* resource */
@@ -3169,35 +3193,35 @@
 #endif
 );
 
-extern XLowerWindow(
+extern void XLowerWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XMapRaised(
+extern void XMapRaised(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XMapSubwindows(
+extern void XMapSubwindows(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XMapWindow(
+extern void XMapWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XMaskEvent(
+extern void XMaskEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     long		/* event_mask */,
@@ -3217,7 +3241,7 @@
 #endif
 );
 
-extern XMoveResizeWindow(
+extern void XMoveResizeWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3228,7 +3252,7 @@
 #endif
 );
 
-extern XMoveWindow(
+extern void XMoveWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3237,14 +3261,14 @@
 #endif
 );
 
-extern XNextEvent(
+extern void XNextEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XEvent*		/* event_return */
 #endif
 );
 
-extern XNoOp(
+extern void XNoOp(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
@@ -3269,14 +3293,14 @@
 #endif
 );
 
-extern XPeekEvent(
+extern void XPeekEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XEvent*		/* event_return */
 #endif
 );
 
-extern XPeekIfEvent(
+extern void XPeekIfEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XEvent*		/* event_return */,
@@ -3317,14 +3341,14 @@
 );
 
 
-extern XPutBackEvent(
+extern void XPutBackEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XEvent*		/* event */
 #endif
 );
 
-extern XPutImage(
+extern void XPutImage(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Drawable		/* d */,
@@ -3390,7 +3414,7 @@
 #endif
 );
 
-extern XQueryColor(
+extern void XQueryColor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */,
@@ -3398,7 +3422,7 @@
 #endif
 );
 
-extern XQueryColors(
+extern void XQueryColors(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */,
@@ -3417,7 +3441,7 @@
 #endif
 );
 
-extern XQueryKeymap(
+extern void XQueryKeymap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     char [32]		/* keys_return */
@@ -3438,7 +3462,7 @@
 #endif
 );
 
-extern XQueryTextExtents(
+extern void XQueryTextExtents(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XID			/* font_ID */,
@@ -3451,7 +3475,7 @@
 #endif
 );
 
-extern XQueryTextExtents16(
+extern void XQueryTextExtents16(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XID			/* font_ID */,
@@ -3475,7 +3499,7 @@
 #endif
 );
 
-extern XRaiseWindow(
+extern void XRaiseWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
@@ -3506,7 +3530,7 @@
 #endif
 );
 
-extern XRebindKeysym(
+extern void XRebindKeysym(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     KeySym		/* keysym */,
@@ -3517,7 +3541,7 @@
 #endif
 );
 
-extern XRecolorCursor(
+extern void XRecolorCursor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Cursor		/* cursor */,
@@ -3526,27 +3550,27 @@
 #endif
 );
 
-extern XRefreshKeyboardMapping(
+extern void XRefreshKeyboardMapping(
 #if NeedFunctionPrototypes
     XMappingEvent*	/* event_map */    
 #endif
 );
 
-extern XRemoveFromSaveSet(
+extern void XRemoveFromSaveSet(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XRemoveHost(
+extern void XRemoveHost(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XHostAddress*	/* host */
 #endif
 );
 
-extern XRemoveHosts(
+extern void XRemoveHosts(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     XHostAddress*	/* hosts */,
@@ -3554,7 +3578,7 @@
 #endif
 );
 
-extern XReparentWindow(
+extern void XReparentWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3564,13 +3588,13 @@
 #endif
 );
 
-extern XResetScreenSaver(
+extern void XResetScreenSaver(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XResizeWindow(
+extern void XResizeWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3579,7 +3603,7 @@
 #endif
 );
 
-extern XRestackWindows(
+extern void XRestackWindows(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window*		/* windows */,
@@ -3587,14 +3611,14 @@
 #endif
 );
 
-extern XRotateBuffers(
+extern void XRotateBuffers(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* rotate */
 #endif
 );
 
-extern XRotateWindowProperties(
+extern void XRotateWindowProperties(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3610,7 +3634,7 @@
 #endif
 );
 
-extern XSelectInput(
+extern void XSelectInput(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3628,14 +3652,14 @@
 #endif
 );
 
-extern XSetAccessControl(
+extern void XSetAccessControl(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* mode */
 #endif
 );
 
-extern XSetArcMode(
+extern void XSetArcMode(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3643,7 +3667,7 @@
 #endif
 );
 
-extern XSetBackground(
+extern void XSetBackground(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3651,7 +3675,7 @@
 #endif
 );
 
-extern XSetClipMask(
+extern void XSetClipMask(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3659,7 +3683,7 @@
 #endif
 );
 
-extern XSetClipOrigin(
+extern void XSetClipOrigin(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3668,7 +3692,7 @@
 #endif
 );
 
-extern XSetClipRectangles(
+extern void XSetClipRectangles(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3680,14 +3704,14 @@
 #endif
 );
 
-extern XSetCloseDownMode(
+extern void XSetCloseDownMode(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* close_mode */
 #endif
 );
 
-extern XSetCommand(
+extern void XSetCommand(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3696,7 +3720,7 @@
 #endif
 );
 
-extern XSetDashes(
+extern void XSetDashes(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3706,7 +3730,7 @@
 #endif
 );
 
-extern XSetFillRule(
+extern void XSetFillRule(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3714,7 +3738,7 @@
 #endif
 );
 
-extern XSetFillStyle(
+extern void XSetFillStyle(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3722,7 +3746,7 @@
 #endif
 );
 
-extern XSetFont(
+extern void XSetFont(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3730,7 +3754,7 @@
 #endif
 );
 
-extern XSetFontPath(
+extern int XSetFontPath(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     char**		/* directories */,
@@ -3738,7 +3762,7 @@
 #endif
 );
 
-extern XSetForeground(
+extern void XSetForeground(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3746,7 +3770,7 @@
 #endif
 );
 
-extern XSetFunction(
+extern void XSetFunction(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3754,7 +3778,7 @@
 #endif
 );
 
-extern XSetGraphicsExposures(
+extern void XSetGraphicsExposures(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3762,7 +3786,7 @@
 #endif
 );
 
-extern XSetIconName(
+extern void XSetIconName(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3770,7 +3794,7 @@
 #endif
 );
 
-extern XSetInputFocus(
+extern void XSetInputFocus(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* focus */,
@@ -3779,7 +3803,7 @@
 #endif
 );
 
-extern XSetLineAttributes(
+extern void XSetLineAttributes(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3797,7 +3821,7 @@
 #endif
 );
 
-extern XSetPlaneMask(
+extern void XSetPlaneMask(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3813,7 +3837,7 @@
 #endif
 );
 
-extern XSetScreenSaver(
+extern void XSetScreenSaver(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* timeout */,
@@ -3823,7 +3847,7 @@
 #endif
 );
 
-extern XSetSelectionOwner(
+extern void XSetSelectionOwner(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Atom	        /* selection */,
@@ -3832,7 +3856,7 @@
 #endif
 );
 
-extern XSetState(
+extern void XSetState(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3843,7 +3867,7 @@
 #endif
 );
 
-extern XSetStipple(
+extern void XSetStipple(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3851,7 +3875,7 @@
 #endif
 );
 
-extern XSetSubwindowMode(
+extern void XSetSubwindowMode(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3859,7 +3883,7 @@
 #endif
 );
 
-extern XSetTSOrigin(
+extern void XSetTSOrigin(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3868,7 +3892,7 @@
 #endif
 );
 
-extern XSetTile(
+extern void XSetTile(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     GC			/* gc */,
@@ -3876,7 +3900,7 @@
 #endif
 );
 
-extern XSetWindowBackground(
+extern void XSetWindowBackground(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3884,7 +3908,7 @@
 #endif
 );
 
-extern XSetWindowBackgroundPixmap(
+extern void XSetWindowBackgroundPixmap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3892,7 +3916,7 @@
 #endif
 );
 
-extern XSetWindowBorder(
+extern void XSetWindowBorder(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3900,7 +3924,7 @@
 #endif
 );
 
-extern XSetWindowBorderPixmap(
+extern void XSetWindowBorderPixmap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3908,7 +3932,7 @@
 #endif
 );
 
-extern XSetWindowBorderWidth(
+extern void XSetWindowBorderWidth(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3916,7 +3940,7 @@
 #endif
 );
 
-extern XSetWindowColormap(
+extern void XSetWindowColormap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3924,7 +3948,7 @@
 #endif
 );
 
-extern XStoreBuffer(
+extern void XStoreBuffer(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     _Xconst char*	/* bytes */,
@@ -3933,7 +3957,7 @@
 #endif
 );
 
-extern XStoreBytes(
+extern void XStoreBytes(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     _Xconst char*	/* bytes */,
@@ -3941,7 +3965,7 @@
 #endif
 );
 
-extern XStoreColor(
+extern void XStoreColor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */,
@@ -3949,7 +3973,7 @@
 #endif
 );
 
-extern XStoreColors(
+extern void XStoreColors(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */,
@@ -3958,7 +3982,7 @@
 #endif
 );
 
-extern XStoreName(
+extern void XStoreName(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
@@ -3966,7 +3990,7 @@
 #endif
 );
 
-extern XStoreNamedColor(
+extern void XStoreNamedColor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */,
@@ -3976,14 +4000,14 @@
 #endif
 );
 
-extern XSync(
+extern void XSync(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Bool		/* discard */
 #endif
 );
 
-extern XTextExtents(
+extern void XTextExtents(
 #if NeedFunctionPrototypes
     XFontStruct*	/* font_struct */,
     _Xconst char*	/* string */,
@@ -3995,7 +4019,7 @@
 #endif
 );
 
-extern XTextExtents16(
+extern void XTextExtents16(
 #if NeedFunctionPrototypes
     XFontStruct*	/* font_struct */,
     _Xconst XChar2b*	/* string */,
@@ -4036,14 +4060,14 @@
 #endif
 );
 
-extern XUndefineCursor(
+extern void XUndefineCursor(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XUngrabButton(
+extern void XUngrabButton(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     unsigned int	/* button */,
@@ -4052,7 +4076,7 @@
 #endif
 );
 
-extern XUngrabKey(
+extern void XUngrabKey(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     int			/* keycode */,
@@ -4061,48 +4085,48 @@
 #endif
 );
 
-extern XUngrabKeyboard(
+extern void XUngrabKeyboard(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Time		/* time */
 #endif
 );
 
-extern XUngrabPointer(
+extern void XUngrabPointer(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Time		/* time */
 #endif
 );
 
-extern XUngrabServer(
+extern void XUngrabServer(
 #if NeedFunctionPrototypes
     Display*		/* display */
 #endif
 );
 
-extern XUninstallColormap(
+extern void XUninstallColormap(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Colormap		/* colormap */
 #endif
 );
 
-extern XUnloadFont(
+extern void XUnloadFont(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Font		/* font */
 #endif
 );
 
-extern XUnmapSubwindows(
+extern void XUnmapSubwindows(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
 #endif
 );
 
-extern XUnmapWindow(
+extern void XUnmapWindow(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */
@@ -4115,7 +4139,7 @@
 #endif
 );
 
-extern XWarpPointer(
+extern void XWarpPointer(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* src_w */,
@@ -4141,7 +4165,7 @@
 #endif
 );
 
-extern XWindowEvent(
+extern void XWindowEvent(
 #if NeedFunctionPrototypes
     Display*		/* display */,
     Window		/* w */,
