--- OLD/xc/lib/X11/SetGetCols.c	Thu Jan  1 00:00:00 1970
+++ NEW/xc/lib/X11/SetGetCols.c	Thu Jan  1 00:00:00 1970
@@ -64,9 +64,9 @@
  *	SYNOPSIS
  */
 Status
-_XcmsSetGetColors(xColorProc, dpy, cmap, pColors_in_out, nColors,
+_XcmsSetGetColors(xColorOp, dpy, cmap, pColors_in_out, nColors,
 	result_format, pCompressed)
-    Status (*xColorProc)();
+    enum _XcmsSGCProc xColorOp;
     Display *dpy;
     Colormap cmap;
     XcmsColor *pColors_in_out;
@@ -95,7 +95,7 @@
 
     /*
      * Argument Checking
-     *	1. Assume xColorProc is correct
+     *	1. Assume xColorOp is correct
      *	2. Insure ccc not NULL
      *	3. Assume cmap correct (should be checked by Server)
      *	4. Insure pColors_in_out valid
@@ -115,19 +115,26 @@
 	return(XcmsFailure);
     }
 
-    if (!((*xColorProc == XAllocColor) || (*xColorProc == XStoreColor)
-	    || (*xColorProc == XStoreColors) || (*xColorProc == XQueryColor) 
-	    || (*xColorProc == XQueryColors))) {
-	return(XcmsFailure);
+    switch (xColorOp) {
+	case _Xcms_QueryColor:
+	case _Xcms_QueryColors:
+	case _Xcms_StoreColor:
+	case _Xcms_StoreColors:
+	case _Xcms_AllocColor:
+	    break;
+	default:
+	    return(XcmsFailure);
     }
 
     if ((ccc = XcmsCCCOfColormap(dpy, cmap)) == (XcmsCCC)NULL) {
 	return(XcmsFailure);
     }
 
-    if ((*xColorProc == XAllocColor) || (*xColorProc == XStoreColor)
-	    || (*xColorProc == XQueryColor)) {
-	nColors = 1;
+    switch (xColorOp) {
+	case _Xcms_AllocColor:
+	case _Xcms_StoreColor:
+	case _Xcms_QueryColor:
+	    nColors = 1;
     }
 
     /*
@@ -138,8 +145,10 @@
 	return(XcmsFailure);
     }
 
-    if ((*xColorProc == XQueryColor) || (*xColorProc == XQueryColors)) {
-	goto Query;
+    switch (xColorOp) {
+	case _Xcms_QueryColor:
+	case _Xcms_QueryColors:
+	    goto Query;
     }
     /*
      * Convert to RGB, adjusting for white point differences if necessary.
@@ -158,25 +167,32 @@
     /*
      * Now make appropriate X Call
      */
-    if (*xColorProc == XAllocColor) {
-	if ((*xColorProc)(ccc->dpy, cmap, pXColors_in_out) == 0) {
+    switch (xColorOp) {
+	case _Xcms_AllocColor:
+	    if (XAllocColor(ccc->dpy, cmap, pXColors_in_out) == 0) {
+		Xfree((char *)pXColors_in_out);
+		return(XcmsFailure);
+	    }
+	    break;
+	case _Xcms_QueryColor:
+	    XQueryColor(ccc->dpy, cmap, pXColors_in_out);
+	    break;
+	case _Xcms_StoreColor:
+	    XStoreColor(ccc->dpy, cmap, pXColors_in_out);
+	    Xfree((char *)pXColors_in_out);
+	    return(retval);
+	    break;
+	case _Xcms_QueryColors:
+	    XQueryColors(ccc->dpy, cmap, pXColors_in_out, nColors);
+	    break;
+	case _Xcms_StoreColors:
+	    XStoreColors(ccc->dpy, cmap, pXColors_in_out, nColors);
+	    Xfree((char *)pXColors_in_out);
+	    return(retval);
+	    break;
+	default: /* is this possible? */
 	    Xfree((char *)pXColors_in_out);
 	    return(XcmsFailure);
-	}
-    } else if ((*xColorProc == XQueryColor) || (*xColorProc == XStoreColor)) {
-	/* Note: XQueryColor and XStoreColor do not return any Status */
-	(*xColorProc)(ccc->dpy, cmap, pXColors_in_out);
-    } else if ((*xColorProc == XQueryColors) || (*xColorProc == XStoreColors)){
-	/* Note: XQueryColors and XStoreColors do not return any Status */
-	(*xColorProc)(ccc->dpy, cmap, pXColors_in_out, nColors);
-    } else {
-	Xfree((char *)pXColors_in_out);
-	return(XcmsFailure);
-    }
-
-    if ((*xColorProc == XStoreColor) || (*xColorProc == XStoreColors)) {
-	Xfree((char *)pXColors_in_out);
-	return(retval);
     }
 
     /*
