--- OLD/xc/config/makedepend/main.c	Thu Jan  1 00:00:00 1970
+++ NEW/xc/config/makedepend/main.c	Thu Jan  1 00:00:00 1970
@@ -154,15 +154,17 @@
 	    char **nargv;
 	    int nargc;
 	    char quotechar = '\0';
+	    int asize;
 
 	    nargc = 1;
 	    if ((afd = open(argv[1]+1, O_RDONLY)) < 0)
 		fatalerr("cannot open \"%s\"\n", argv[1]+1);
 	    fstat(afd, &ast);
-	    args = (char *)malloc(ast.st_size + 1);
-	    if ((ast.st_size = read(afd, args, ast.st_size)) < 0)
+	    asize = ast.st_size;
+	    args = (char *)malloc(asize + 1);
+	    if ((asize = read(afd, args, asize)) < 0)
 		fatalerr("failed to read %s\n", argv[1]+1);
-	    args[ast.st_size] = '\0';
+	    args[asize] = '\0';
 	    close(afd);
 	    for (p = args; *p; p++) {
 		if (quotechar) {
@@ -422,6 +424,7 @@
 	register int	fd;
 	struct filepointer	*content;
 	struct stat	st;
+	int size;
 
 	content = (struct filepointer *)malloc(sizeof(struct filepointer));
 	if ((fd = open(file, O_RDONLY)) < 0) {
@@ -431,15 +434,17 @@
 		return(content);
 	}
 	fstat(fd, &st);
-	content->f_base = (char *)malloc(st.st_size+1);
+	size = st.st_size;
+	content->f_base = (char *)malloc(size+1);
 	if (content->f_base == NULL)
 		fatalerr("cannot allocate mem\n");
-	if ((st.st_size = read(fd, content->f_base, st.st_size)) < 0)
+	if ((size = read(fd, content->f_base, size)) < 0)
 		fatalerr("failed to read %s\n", file);
+	/* XXX should check that we read as much as we wanted to! */
 	close(fd);
-	content->f_len = st.st_size+1;
+	content->f_len = size+1;
 	content->f_p = content->f_base;
-	content->f_end = content->f_base + st.st_size;
+	content->f_end = content->f_base + size;
 	*content->f_end = '\0';
 	content->f_line = 0;
 	return(content);
