#include <pwd.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>

extern const char *__progname;

static const char *binary = "&($REALMAKEBIN=/usr/bin/make)";

static const char *args[] = { "-m", "&($LOCALROOT=/local)/lib/make",
			      "-m", "/usr/share/mk",
			      0 };

static char *and_envar(const char **sp)
{
 const char *s;
 const char *s0;
 int l;
 char *t;
 char *e;

 s = *sp;
 s0 = ++s;
 while (*s && (*s != ')') && (*s != '=')) s ++;
 if (! *s) return(0);
 l = s - s0;
 t = malloc(l+1);
 bcopy(s0,t,l);
 t[l] = '\0';
 e = getenv(t);
 free(t);
 if (e)
  { while (*s && (*s != ')')) s ++;
    if (! *s) return(0);
    t = malloc(strlen(e)+1);
    strcpy(t,e);
  }
 else
  { if (*s == '=')
     { s0 = ++s;
       while (*s && (*s != ')')) s ++;
       if (! *s) return(0);
       l = s - s0;
       t = malloc(l+1);
       bcopy(s0,t,l);
       t[l] = '\0';
     }
    else
     { t = malloc(1);
       t[0] = '\0';
     }
  }
 *sp = s + 1;
 return(t);
}

static char *and_home(const char **sp)
{
 const char *s;
 const char *s0;
 int l;
 char *t;
 struct passwd *pw;

 s = *sp;
 s0 = ++s;
 while (*s && (*s != ')')) s ++;
 if (! *s) return(0);
 l = s - s0;
 t = malloc(l+1);
 bcopy(s0,t,l);
 t[l] = '\0';
 pw = getpwnam(t);
 free(t);
 if (pw == 0) return(0);
 l = strlen(pw->pw_dir);
 t = malloc(l+1);
 strcpy(t,pw->pw_dir);
 *sp = s + 1;
 return(t);
}

static char *and_result(const char **sp)
{
 switch (**sp)
  { case '$':
       return(and_envar(sp));
       break;
    case '~':
       return(and_home(sp));
       break;
  }
 return(0);
}

static const char *and_process(const char *s)
{
 char *rv;
 int rvl;
 int rvh;
 char *app;
 char *appf;
 char c;

 if (! index(s,'&')) return(s);
 rv = malloc(1);
 rvl = 0;
 rvh = 0;
 app = 0;
 while (1)
  { if (app)
     { if (*app)
	{ c = *app++;
	}
       else
	{ free(appf);
	  app = 0;
	  continue;
	}
     }
    else
     { switch (*s)
	{ case '\0':
	     rv[rvl] = '\0';
	     return(rv);
	     break;
	  case '&':
	     switch (s[1])
	      { case '\0':
		   c = '&';
		   s ++;
		   break;
		case '(':
		   s += 2;
		   app = and_result(&s);
		   appf = app;
		   continue;
		   break;
		default:
		   s += 2;
		   c = s[-1];
		   break;
	      }
	     break;
	  default:
	     c = *s++;
	     break;
	}
     }
    if (rvl >= rvh) rv = realloc(rv,(rvh=rvl+16)+1);
    rv[rvl++] = c;
  }
}

int main(int, char **);
int main(int ac, char **av)
{
 int nargs;
 int i;
 int j;
 const char **newav;
 const char *bin;

 for (i=0;args[i];i++) ;
 nargs = 1 + i + (ac-1) + 1;
 newav = malloc(nargs*sizeof(*newav));
 j = 0;
 bin = and_process(binary);
 newav[j++] = bin;
 for (i=0;args[i];i++) newav[j++] = and_process(args[i]);
 for (i=1;av[i];i++) newav[j++] = av[i];
 newav[j] = 0;
 execv(bin,(const void *)newav);
 fprintf(stderr,"%s: %s: %s\n",__progname,bin,strerror(errno));
 exit(1);
}
