--- OLD/xc/programs/Xserver/hw/sun/sunInit.c	Thu Jan  1 00:00:00 1970
+++ NEW/xc/programs/Xserver/hw/sun/sunInit.c	Thu Jan  1 00:00:00 1970
@@ -170,10 +170,13 @@
 
 Bool sunAutoRepeatHandlersInstalled;	/* FALSE each time InitOutput called */
 Bool sunSwapLkeys = FALSE;
+Bool sunSoftCursor = FALSE;
 Bool sunFlipPixels = FALSE;
 Bool sunFbInfo = FALSE;
 Bool sunCG4Frob = FALSE;
 Bool sunNoGX = FALSE;
+const char *sunKbdDev = 0;
+const char *sunMouseDev = 0;
 
 sunKbdPrivRec sunKbdPriv = {
     -1,		/* fd */
@@ -521,6 +524,7 @@
 {
     static int inited;
     if (!inited) {
+	const char *dev;
 #ifndef i386
 	struct rlimit rl;
 
@@ -535,12 +539,14 @@
 	    (void) setrlimit (RLIMIT_NOFILE, &rl);
 	}
 #endif
-	sunKbdPriv.fd = open ("/dev/kbd", O_RDWR, 0);
+	dev = sunKbdDev ? sunKbdDev : "/dev/kbd";
+	sunKbdPriv.fd = open (dev, O_RDWR, 0);
 	if (sunKbdPriv.fd < 0)
-	    FatalError ("Cannot open /dev/kbd, error %d\n", errno);
-	sunPtrPriv.fd = open ("/dev/mouse", O_RDWR, 0);
+	    FatalError ("Cannot open %s, error %d\n", dev, errno);
+	dev = sunMouseDev ? sunMouseDev : "/dev/mouse";
+	sunPtrPriv.fd = open (dev, O_RDWR, 0);
 	if (sunPtrPriv.fd < 0)
-	    FatalError ("Cannot open /dev/mouse, error %d\n", errno);
+	    FatalError ("Cannot open %s, error %d\n", dev, errno);
 	getKbdType ();
 	if (sunKbdPriv.type == KB_SUN4) {
 	    (void) ioctl (sunKbdPriv.fd, KIOCLAYOUT, &sunKbdPriv.layout);
