--- OLD/xc/programs/Xserver/cfb/cfbmskbits.h	Thu Jan  1 00:00:00 1970
+++ NEW/xc/programs/Xserver/cfb/cfbmskbits.h	Thu Jan  1 00:00:00 1970
@@ -635,6 +635,7 @@
  * XXX Works with both byte order.
  * XXX This works for all values of x and w within a doubleword.
  */
+/* getstipplepixelsmask() is for PSZ==2, below. */
 #if (BITMAP_BIT_ORDER == MSBFirst)
 #define getstipplepixels( psrcstip, x, w, ones, psrcpix, destpix ) \
 { \
@@ -648,7 +649,7 @@
     else \
         q = (*(psrcstip)) >> -m; \
     q = QuartetBitsTable[(w)] & ((ones) ? q : ~q); \
-    *(destpix) = (*(psrcpix)) & QuartetPixelMaskTable[q]; \
+    *(destpix) = (*(psrcpix)) & getstipplepixelsmask(q); \
 }
 #else /* BITMAP_BIT_ORDER == LSB */
 #define getstipplepixels( psrcstip, xt, w, ones, psrcpix, destpix ) \
@@ -658,9 +659,10 @@
     if ( ((xt)+(w)) > (PPW*PSZ) ) \
         q |= (*((psrcstip)+1)) << ((PPW*PSZ)-(xt)); \
     q = QuartetBitsTable[(w)] & ((ones) ? q : ~q); \
-    *(destpix) = (*(psrcpix)) & QuartetPixelMaskTable[q]; \
+    *(destpix) = (*(psrcpix)) & getstipplepixelsmask(q); \
 }
 #endif
+#define getstipplepixelsmask(q) QuartetPixelMaskTable[q]
 
 extern PixelGroup cfbstarttab[];
 extern PixelGroup cfbendtab[];
@@ -670,3 +672,25 @@
 extern PixelGroup cfbmask[];
 extern PixelGroup QuartetBitsTable[];
 extern PixelGroup QuartetPixelMaskTable[];
+
+#if PSZ==2
+/* Kludges.  Done navely, QuartetPixelMaskTable would be a 64K-entry table
+   for PGSZ=32 and a 4G-entry table for PGSZ=64.  So instead we define
+   QuartetPixelMask8Table, a 256-entry table, and use it twice for PGSZ=32
+   and four times for PGSZ=64. */
+extern PixelGroup QuartetPixelMask8Table[];
+#undef getstipplepixelsmask(q)
+#if PGSZ == 32
+#define getstipplepixelsmask(q)						\
+	( QuartetPixelMask8Table[q&0xff] |				\
+	  (QuartetPixelMask8Table[q>>8]<<16) )
+#elif PGSZ == 64
+#define getstipplepixelsmask(q)						\
+	( QuartetPixelMask8Table[q&0xff] |				\
+	  (QuartetPixelMask8Table[(q>>8)&0xff]<<16) |			\
+	  (QuartetPixelMask8Table[(q>>16)&0xff]<<32) |			\
+	  (QuartetPixelMask8Table[q>>24]<<48) )
+#else
+#error "PSZ 2 and PGSZ neither 32 nor 64 is not supported."
+#endif
+#endif /* PSZ==2 */
