--- OLD/xc/lib/X11/Region.c	Thu Jan  1 00:00:00 1970
+++ NEW/xc/lib/X11/Region.c	Thu Jan  1 00:00:00 1970
@@ -104,7 +104,7 @@
     return( temp );
 }
 
-XClipBox( r, rect )
+void XClipBox( r, rect )
     Region r;
     XRectangle *rect;
 {
@@ -112,17 +112,16 @@
     rect->y = r->extents.y1;
     rect->width = r->extents.x2 - r->extents.x1;
     rect->height = r->extents.y2 - r->extents.y1;
-    return 1;
 }
 
-XUnionRectWithRegion(rect, source, dest)
+void XUnionRectWithRegion(rect, source, dest)
     register XRectangle *rect;
     Region source, dest;
 {
     REGION region;
 
     if (!rect->width || !rect->height)
-	return 0;
+	return;
     region.rects = &region.extents;
     region.numRects = 1;
     region.extents.x1 = rect->x;
@@ -131,7 +130,7 @@
     region.extents.y2 = rect->y + rect->height;
     region.size = 1;
 
-    return XUnionRegion(&region, source, dest);
+    XUnionRegion(&region, source, dest);
 }
 
 /*-
@@ -198,7 +197,7 @@
     assert(pExtents->x1 < pExtents->x2);
 }
 
-XSetRegion( dpy, gc, r )
+void XSetRegion( dpy, gc, r )
     Display *dpy;
     GC gc;
     register Region r;
@@ -225,15 +224,13 @@
 	_XFreeTemp(dpy, (char *)xr, total);
     UnlockDisplay(dpy);
     SyncHandle();
-    return 1;
 }
 
-XDestroyRegion( r )
+void XDestroyRegion( r )
     Region r;
 {
     Xfree( (char *) r->rects );
     Xfree( (char *) r );
-    return 1;
 }
 
 
@@ -242,7 +239,7 @@
    added by raymond
 */
 
-XOffsetRegion(pRegion, x, y)
+void XOffsetRegion(pRegion, x, y)
     register Region pRegion;
     register int x;
     register int y;
@@ -265,7 +262,6 @@
     pRegion->extents.x2 += x;
     pRegion->extents.y1 += y;
     pRegion->extents.y2 += y;
-    return 1;
 }
 
 /* 
@@ -321,15 +317,15 @@
 #undef ZShiftRegion
 #undef ZCopyRegion
 
-XShrinkRegion(r, dx, dy)
+void XShrinkRegion(r, dx, dy)
     Region r;
     int dx, dy;
 {
     Region s, t;
     int grow;
 
-    if (!dx && !dy) return 0;
-    if ((! (s = XCreateRegion()))  || (! (t = XCreateRegion()))) return 0;
+    if (!dx && !dy) return;
+    if ((! (s = XCreateRegion()))  || (! (t = XCreateRegion()))) return;
     if (grow = (dx < 0)) dx = -dx;
     if (dx) Compress(r, s, t, (unsigned) 2*dx, TRUE, grow);
     if (grow = (dy < 0)) dy = -dy;
@@ -337,7 +333,6 @@
     XOffsetRegion(r, dx, dy);
     XDestroyRegion(s);
     XDestroyRegion(t);
-    return 0;
 }
 
 #ifdef notdef
@@ -439,7 +434,7 @@
     return 0;	/* lint */
 }
 
-XIntersectRegion(reg1, reg2, newReg)
+void XIntersectRegion(reg1, reg2, newReg)
     Region 	  	reg1;
     Region	  	reg2;          /* source regions     */
     register Region 	newReg;               /* destination Region */
@@ -460,7 +455,6 @@
      * due to coalescing, so we have to examine fewer rectangles.
      */
     miSetExtents(newReg);
-    return 1;
 }
 
 static void
@@ -1202,7 +1196,7 @@
     return 0;	/* lint */
 }
 
-XUnionRegion(reg1, reg2, newReg)
+void XUnionRegion(reg1, reg2, newReg)
     Region 	  reg1;
     Region	  reg2;             /* source regions     */
     Region 	  newReg;                  /* destination Region */
@@ -1216,7 +1210,7 @@
     {
         if (newReg != reg2)
             miRegionCopy(newReg, reg2);
-        return 1;
+        return;
     }
 
     /*
@@ -1226,7 +1220,7 @@
     {
         if (newReg != reg1)
             miRegionCopy(newReg, reg1);
-        return 1;
+        return;
     }
 
     /*
@@ -1240,7 +1234,7 @@
     {
         if (newReg != reg1)
             miRegionCopy(newReg, reg1);
-        return 1;
+        return;
     }
 
     /*
@@ -1254,7 +1248,7 @@
     {
         if (newReg != reg2)
             miRegionCopy(newReg, reg2);
-        return 1;
+        return;
     }
 
     miRegionOp (newReg, reg1, reg2, (voidProcp) miUnionO, 
@@ -1264,8 +1258,6 @@
     newReg->extents.y1 = min(reg1->extents.y1, reg2->extents.y1);
     newReg->extents.x2 = max(reg1->extents.x2, reg2->extents.x2);
     newReg->extents.y2 = max(reg1->extents.y2, reg2->extents.y2);
-
-    return 1;
 }
 
 
@@ -1483,7 +1475,7 @@
  *-----------------------------------------------------------------------
  */
 
-XSubtractRegion(regM, regS, regD)
+void XSubtractRegion(regM, regS, regD)
     Region 	  	regM;
     Region	  	regS;          
     register Region	regD;
@@ -1493,7 +1485,7 @@
 	(!EXTENTCHECK(&regM->extents, &regS->extents)) )
     {
 	miRegionCopy(regD, regM);
-        return 1;
+        return;
     }
  
     miRegionOp (regD, regM, regS, (voidProcp) miSubtractO, 
@@ -1507,22 +1499,20 @@
      * due to coalescing, so we have to examine fewer rectangles.
      */
     miSetExtents (regD);
-    return 1;
 }
 
-XXorRegion( sra, srb, dr )
+void XXorRegion( sra, srb, dr )
     Region sra, srb, dr;
 {
     Region tra, trb;
 
     if ((! (tra = XCreateRegion())) || (! (trb = XCreateRegion())))
-	return 0;
+	return;
     (void) XSubtractRegion(sra,srb,tra);
     (void) XSubtractRegion(srb,sra,trb);
     (void) XUnionRegion(tra,trb,dr);
     XDestroyRegion(tra);
     XDestroyRegion(trb);
-    return 0;
 }
 
 /*
