#include <pwd.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <sys/wait.h>

static const char ccpgm[] = "/usr/bin/cc";
static const char *extra[] = { "-I&(~mouse)/.local/include",
			       "-I&(~mouse)/.local/include-shadow",
			       "-I&($LOCALROOT=/local)/include",
			       "-L&($LOCALROOT=/local)/lib",
			       "-R&($LOCALROOT=/local)/lib",
			       "-B&(~mouse)/.local/lib/cc/" };
static const char *subst[][2] = { { "-V", "-v" } };
static const char *envvar[] = { "C_OPTS", 0 };
static const char *debug_env = "CC_DEBUG";

static int nextra = sizeof(extra) / sizeof(extra[0]);
static int nsubst = sizeof(subst) / sizeof(subst[0]);
static const char **newav;
static char **envav;
static int nenv;
static int debugging;

static char ccline[1024];

#define NSTART 1
#define NINC 1
static void readenv(void)
{
 int i;
 int have;
 int used;
 char *ep;
 char *cp;
 char *dp;
 char backslash;

 envav = 0;
 for (i=0;envvar[i];i++)
  { ep = getenv(envvar[i]);
    if (ep) break;
    if (debugging)
     { printf("no `%s' in environment\n",envvar[i]);
     }
  }
 if (ep == 0)
  { static char *zblk[] = { 0 };
    envav = zblk;
    nenv = 0;
    if (debugging)
     { printf("no options variable found in environment\n");
     }
    return;
  }
 if (debugging)
  { printf("getenv(\"%s\") -> `%s'\n",envvar[i],ep);
  }
 have = NSTART;
 envav = (char **) malloc((NSTART+1)*sizeof(char *));
 used = 0;
 backslash = 0;
 cp = ep;
 while (*cp)
  { if (*cp == ' ')
     { cp ++;
       continue;
     }
    if (used >= have)
     { have += NINC;
       envav = (char **) realloc((char *)envav,(have+1)*sizeof(char *));
     }
    envav[used++] = cp;
    if (debugging)
     { printf("new arg at `%s'\n",cp);
     }
    dp = cp;
    while (*cp && (backslash || (*cp != ' ')))
     { if ((*cp == '\\') && !backslash)
	{ cp ++;
	  backslash = 1;
	  continue;
	}
       *dp++ = *cp++;
       backslash = 0;
     }
    if (*cp)
     { *dp++ = '\0';
       cp ++;
     }
    else
     { *dp = '\0';
     }
    if (debugging)
     { printf("arg finished as `%s'\n",envav[used-1]);
     }
  }
 nenv = used;
 envav[used] = '\0';
 if (debugging)
  { printf("%d from environment\n",nenv);
  }
}
#undef NSTART
#undef NINC

static int linecontains(const char *str)
{
 const char *lp;
 const char *sp;

 sp = str;
 lp = &ccline[0];
 while (1)
  { if (!*sp) return(1);
    if (!*lp) return(0);
    if (*sp == *lp)
     { sp ++;
     }
    else if (sp != str)
     { lp -= sp - str;
       sp = str;
     }
    lp ++;
  }
}

static int linebegins(const char *str)
{
 return(!bcmp(&ccline[0],str,strlen(str)));
}

static char *and_envar(const char **sp)
{
 const char *s;
 const char *s0;
 int l;
 char *t;
 char *e;

 s = *sp;
 s0 = ++s;
 while (*s && (*s != ')') && (*s != '=')) s ++;
 if (! *s) return(0);
 l = s - s0;
 t = malloc(l+1);
 bcopy(s0,t,l);
 t[l] = '\0';
 e = getenv(t);
 free(t);
 if (e)
  { while (*s && (*s != ')')) s ++;
    if (! *s) return(0);
    t = malloc(strlen(e)+1);
    strcpy(t,e);
  }
 else
  { if (*s == '=')
     { s0 = ++s;
       while (*s && (*s != ')')) s ++;
       if (! *s) return(0);
       l = s - s0;
       t = malloc(l+1);
       bcopy(s0,t,l);
       t[l] = '\0';
     }
    else
     { t = malloc(1);
       t[0] = '\0';
     }
  }
 *sp = s + 1;
 return(t);
}

static char *and_home(const char **sp)
{
 const char *s;
 const char *s0;
 int l;
 char *t;
 struct passwd *pw;

 s = *sp;
 s0 = ++s;
 while (*s && (*s != ')')) s ++;
 if (! *s) return(0);
 l = s - s0;
 t = malloc(l+1);
 bcopy(s0,t,l);
 t[l] = '\0';
 pw = getpwnam(t);
 free(t);
 if (pw == 0) return(0);
 l = strlen(pw->pw_dir);
 t = malloc(l+1);
 strcpy(t,pw->pw_dir);
 *sp = s + 1;
 return(t);
}

static char *and_result(const char **sp)
{
 switch (**sp)
  { case '$':
       return(and_envar(sp));
       break;
    case '~':
       return(and_home(sp));
       break;
  }
 return(0);
}

static const char *and_process(const char *s)
{
 char *rv;
 int rvl;
 int rvh;
 char *app;
 char *app0;
 char c;

 if (! index(s,'&')) return(s);
 if (debugging) printf("and_process: initial %s\n",s);
 rv = malloc(1);
 rvl = 0;
 rvh = 0;
 app = 0;
 while (1)
  { if (app)
     { if (*app)
	{ c = *app++;
	}
       else
	{ free(app0);
	  app = 0;
	  continue;
	}
     }
    else
     { switch (*s)
	{ case '\0':
	     rv[rvl] = '\0';
	     if (debugging) printf("and_process: returning %s\n",rv);
	     return(rv);
	     break;
	  case '&':
	     switch (s[1])
	      { case '\0':
		   c = '&';
		   s ++;
		   break;
		case '(':
		   s += 2;
		   app0 = app = and_result(&s);
		   continue;
		   break;
		default:
		   s += 2;
		   c = s[-1];
		   break;
	      }
	     break;
	  default:
	     c = *s++;
	     break;
	}
     }
    if (rvl >= rvh) rv = realloc(rv,(rvh=rvl+16)+1);
    rv[rvl++] = c;
  }
}

int main(int, char **);
int main(int ac, char **av)
{
 const char **np;
 int i;
 int j;
 const char *cp;
 int p[2];
 int searchskipping;

 debugging = !!getenv(debug_env);
 readenv();
 newav = malloc((ac+nenv+nextra+1)*sizeof(char *));
 np = newav;
 for (i=0;i<ac;i++)
  { cp = av[i];
    for (j=0;j<nsubst;j++)
     { if (!strcmp(subst[j][0],cp))
	{ cp = subst[j][1];
	  if (debugging)
	   { printf("changing %s into %s\n",subst[j][0],subst[j][1]);
	   }
	  break;
	}
     }
    *np++ = cp;
  }
 for (i=0;i<nenv;i++)
  { *np++ = envav[i];
  }
 for (i=0;i<nextra;i++)
  { *np++ = and_process(extra[i]);
  }
 *np = 0;
 if (debugging)
  { printf("%s arglist:\n",ccpgm);
    for (i=0;newav[i];i++)
     { printf("\t%s\n",newav[i]);
     }
  }
 if (pipe(p) < 0)
  { perror("pipe");
    exit(1);
  }
 i = fork();
 if (i < 0)
  { perror("fork");
    exit(1);
  }
 if (i == 0)
  { close(p[0]);
    if (p[1] != fileno(stderr))
     { dup2(p[1],fileno(stderr));
       close(p[1]);
     }
    execv(ccpgm,(const void *)newav);
    perror(ccpgm);
    exit(1);
  }
 close(p[1]);
 if (p[0] != fileno(stdin))
  { dup2(p[0],fileno(stdin));
    close(p[0]);
  }
 searchskipping = 0;
 while (fgets(&ccline[0],sizeof(ccline),stdin) == &ccline[0])
  { i = strlen(&ccline[0]) - 1;
    if ((i >= 0) && (ccline[i] == '\n')) ccline[i] = '\0';
    if (debugging)
     { fprintf(stderr,"sk=%d line=%s\n",searchskipping,&ccline[0]);
     }
    if ( linebegins("gcc version ") ||
	 linebegins("GNU CPP version ") ||
	 linebegins("GNU C version ") ||
	 linebegins("GNU assembler version ") ||
	 linebegins("cc: file path prefix ") ||
	 linebegins("gcc: file path prefix ") ||
	 linebegins("Reading specs from ") ||
	 linebegins("Using builtin specs") ||
	 linebegins("default target switches ") ||
	 linebegins("cc1: warnings being treated as errors") ||
	 linecontains("(Each undeclared identifier is reported only once") ||
	 linecontains("for each function it appears in.)") ||
	 linecontains("its scope is only this definition or declaration") ||
	 linecontains("which is probably not what you want.") )
     { continue;
     }
    else if (linecontains("search starts here"))
     { searchskipping = 1;
       continue;
     }
    else if (linebegins("End of search list."))
     { searchskipping = 0;
       continue;
     }
    else if (searchskipping)
     { continue;
     }
    else if ( (ccline[0] == ' ') &&
	      ( (ccline[1] == '/') ||
		( (ccline[1] == 'a') &&
		  (ccline[2] == 's') &&
		  (ccline[3] == ' ') ) ||
		( (ccline[1] == 'l') &&
		  (ccline[2] == 'd') &&
		  (ccline[3] == ' ') ) ) )
     { fprintf(stderr,"<cc: %s>\n",&ccline[1]);
     }
    else
     { char *colon;
       char *cp;
       colon = index(&ccline[0],':');
       cp = index(&ccline[0],' ');
       if (colon && (!cp || (colon < cp)) && isdigit(colon[1]))
	{ for (cp=colon+1;*cp&&isdigit(*cp);cp++) ;
	  if (*cp == ':')
	   { fprintf(stderr,"\"%.*s\", line %.*s%s\n",(int)(colon-&ccline[0]),&ccline[0],(int)(cp-(colon+1)),colon+1,cp);
	     ccline[0] = '\0';
	   }
	}
       if (ccline[0]) fprintf(stderr,"%s\n",&ccline[0]);
     }
#ifdef BROKEN_STDIO
    fflush(stderr);
#endif
  }
 while (1)
  { int w;
    i = wait(&w);
    if (i < 0)
     { if (errno == EINTR) continue;
       perror("wait");
       if (errno == ECHILD)
	{ exit(1);
	}
     }
    if (WIFSIGNALED(w))
     { if (WCOREDUMP(w))
	{ fprintf(stderr,"%s dumped core\n",ccpgm);
	  exit(1);
	}
       signal(WTERMSIG(w),SIG_DFL);
       kill(getpid(),WTERMSIG(w));
       exit(1);
     }
    else
     { exit(WEXITSTATUS(w));
     }
  }
}
