#include <md5.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <strings.h>

typedef struct testcase TESTCASE;

struct testcase {
  const char *in;
  const unsigned char right[16];
  int len;
  } ;

static TESTCASE tests[]
 = { { "",
       "\xd4\x1d\x8c\xd9\x8f\x00\xb2\x04\xe9\x80\x09\x98\xec\xf8\x42\x7e" },
     { "a",
       "\x0c\xc1\x75\xb9\xc0\xf1\xb6\xa8\x31\xc3\x99\xe2\x69\x77\x26\x61" },
     { "abc",
       "\x90\x01\x50\x98\x3c\xd2\x4f\xb0\xd6\x96\x3f\x7d\x28\xe1\x7f\x72" },
     { "message digest",
       "\xf9\x6b\x69\x7d\x7c\xb7\x93\x8d\x52\x5a\x2f\x31\xaa\xf1\x61\xd0" },
     { "abcdefghijklmnopqrstuvwxyz",
       "\xc3\xfc\xd3\xd7\x61\x92\xe4\x00\x7d\xfb\x49\x6c\xca\x67\xe1\x3b" },
     { "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
       "\xd1\x74\xab\x98\xd2\x77\xd9\xf5\xa5\x61\x1c\x2c\x9f\x41\x9d\x9f" },
     { "1234567890123456789012345678901234567890"
		"1234567890123456789012345678901234567890",
       "\x57\xed\xf4\xa2\x2b\xe3\xc9\x55\xac\x49\xda\x2e\x21\x07\xb6\x7a" },
     { 0 } };

int main(void);
int main(void)
{
 int i;
 int j;
 void *h;
 void *h2;
 unsigned char r[16];
 unsigned char r2[16];
 int errcount;

 auto void test(const void *, const void *, const char *, ...)
	__attribute__((__format__(__printf__,3,4)));
 void test(const void *resgot, const void *reswant, const char *fmt, ...)
  { va_list ap;
    int j;
    if (!bcmp(resgot,reswant,16)) return;
    va_start(ap,fmt);
    vfprintf(stderr,fmt,ap);
    va_end(ap);
    fprintf(stderr," failure: got ");
    for (j=0;j<16;j++) fprintf(stderr,"%02x",((const unsigned char *)resgot)[j]);
    fprintf(stderr," expected ");
    for (j=0;j<16;j++) fprintf(stderr,"%02x",((const unsigned char *)reswant)[j]);
    fprintf(stderr,"\n");
    errcount ++;
  }

 errcount = 0;
 for (i=0;tests[i].in;i++) tests[i].len = strlen(tests[i].in);
 for (i=0;tests[i].in;i++)
  { h = md5_init();
    md5_process_bytes(h,tests[i].in,tests[i].len);
    md5_result(h,&r[0]);
    test(&r[0],&tests[i].right[0],"single-block %d",i);
  }
 for (i=0;tests[i].in;i++)
  { h = md5_init();
    for (j=0;j<tests[i].len;j++) md5_process_bytes(h,tests[i].in+j,1);
    md5_result(h,&r[0]);
    test(&r[0],&tests[i].right[0],"single-byte %d",i);
  }
 h = md5_init();
 md5_process_bytes(h,"foobar",6);
 md5_result(h,&r[0]);
 h = md5_init();
 md5_process_bytes(h,"foo",3);
 md5_process_bytes(h,"bar",3);
 md5_result(h,&r2[0]);
 test(&r2[0],&r[0],"foo/bar");
 h = md5_init();
 md5_process_bytes(h,"foo",3);
 h2 = md5_clone(h);
 md5_process_bytes(h,"bar",3);
 md5_result(h,&r2[0]);
 test(&r2[0],&r[0],"clone original");
 md5_process_bytes(h2,"bar",3);
 md5_result(h2,&r2[0]);
 test(&r2[0],&r[0],"clone duplicate");
 h = md5_init();
 md5_process_bytes(h,"foo",3);
 i = md5_state(h,0,0);
  { char buf[i];
    int k;
    j = md5_state(h,&buf[0],i);
    if (j > i)
     { fprintf(stderr,"state size failure: expected %d, got %d\n",i,j);
       errcount ++;
     }
    md5_process_bytes(h,"bar",3);
    md5_result(h,&r2[0]);
    test(&r2[0],&r[0],"foo/bar original  state");
    h = md5_init();
    k = md5_set_state(h,&buf[0],j);
    switch (k)
     { case 0:
	  md5_process_bytes(h,"bar",3);
	  md5_result(h,&r2[0]);
	  test(&r2[0],&r[0],"foo/bar copied state");
	  h = 0;
	  break;
       case MD5_BADVERS:
	  printf("bad version state failure\n");
	  errcount ++;
	  break;
       case MD5_CORRUPT:
	  printf("corrupt state failure\n");
	  errcount ++;
	  break;
       default:
	  printf("unknown error %d state failure\n",k);
	  errcount ++;
	  break;
     }
    if (h) md5_drop(h);
  }
 exit(errcount);
}
